//////////////////////////////////////////////////////////////////////////////
//
//  Copyright 2017 Autodesk, Inc.  All rights reserved.
//
//  Use of this software is subject to the terms of the Autodesk license 
//  agreement provided at the time of installation or download, or which 
//  otherwise accompanies this software in either electronic or hard copy form.   
//
//////////////////////////////////////////////////////////////////////////////

#pragma once

#include <max.h>
#include <object.h>
#include <iparamm2.h>

#include <MAXtoA_TranslationInterface.h>

#define MAXtoATestPLUGIN_CLASS_ID Class_ID(0x6705f123, 0xca131123)

using namespace Max::ArnoldTranslator;

class ClassDesc2;

class MAXtoATestPlugin;

class MeshPBValidator : PBValidator
{
    BOOL Validate(PB2Value& v);
    BOOL Validate(PB2Value& v, ReferenceMaker* owner, ParamID id, int tabIndex);
};

//==============================================================================
// class MAXtoATestPluginDesc
//==============================================================================
class MAXtoATestPluginDesc : public ObjLightDesc
{
public:
    MAXtoATestPluginDesc(INode* n) : ObjLightDesc(n) {}

    virtual int Update(TimeValue t, const RendContext &rc, RenderGlobalContext *rgc, BOOL shadows, BOOL shadowGeomChanged) override { return 1; }
    virtual int UpdateViewDepParams(const Matrix3& worldToCam) override { return 1; }
};

//==============================================================================
// class ArnoldLight_CreateCallback
//==============================================================================

class MAXtoATestPlugin_CreateCallback : public CreateMouseCallBack 
{
public:

    static MAXtoATestPlugin_CreateCallback& GetInstance() { return m_theInstance; };

    // -- from CreateMouseCallBack
    int proc(ViewExp *vpt, int msg, int point, int flags, IPoint2 m, Matrix3& mat);

private:
    static MAXtoATestPlugin_CreateCallback m_theInstance;

    MAXtoATestPlugin_CreateCallback();
};

//==============================================================================
// class MAXtoATestPlugin_translationInterface
//==============================================================================

class MAXtoATestPlugin_translationInterface : public MAXtoA_TranslationInterface 
{
public :
    MAXtoATestPlugin_translationInterface(MAXtoATestPlugin* plugin);

    virtual Arnold_translation::TranslationInterface_Result Translate( INode* node,
                            Arnold_translation* arnold_translation,
                            const TimeValue translationTime,
                            Interval& newValidity) override;

    virtual Arnold_translation::TranslationInterface_Result TranslateKeyframe(INode* node,
        const TimeValue frame_time,
        const TimeValue keyframe_time,
        unsigned int keyframe_index) override;

private:
    MAXtoATestPlugin* m_plugin;
};

//==============================================================================
// class MAXtoATestPlugin
//==============================================================================
class MAXtoATestPlugin : public LightObject 
{
    friend class MAXtoATestPlugin_ClassDesc;
    friend class MAXtoATestPlugin_CreateCallback;
    friend class MAXtoATestPlugin_translationInterface;

public:

    typedef struct 
    {
        float x, y, z;
    } XYZ_Color;

    static ClassDesc2& GetClassDesc();

    explicit MAXtoATestPlugin(bool loading);
    virtual ~MAXtoATestPlugin();

    virtual void* GetInterface(ULONG id) override;
    virtual BaseInterface* GetInterface(Interface_ID id) override;

    virtual Class_ID ClassID() override { return GetClassDesc().ClassID(); }
    virtual void DeleteThis() override;
    virtual void GetClassName(TSTR& s) override;
    virtual BOOL IsSubClassOf(Class_ID classID) override;
    virtual int NumSubs() override; 
    virtual Animatable* SubAnim(int i) override;
    virtual TSTR SubAnimName(int i) override;

    void buildMesh(Mesh* mesh, Point3 center) const;
    int Draw(const TimeValue t, ViewExp& vpt, GraphicsWindow& gw, INode& node, const int flags, bool hitTest);
    void DrawShape(const TimeValue t, ViewExp& vpt, GraphicsWindow& gw, INode& node, const int flags, const Color& color);

    IOResult Load(ILoad *iload);
    IOResult Save(ISave *isave);

    virtual void EnumAuxFiles(AssetEnumCallback &nameEnum, DWORD  flags = FILE_ENUM_ALL) override;

    virtual RefTargetHandle	Clone(RemapDir	&remap) override;

    virtual Point3 GetRGBColor(TimeValue t, Interval &valid = Interval(0, 0)) override;

    virtual void BeginEditParams(IObjParam *ip, ULONG flags, Animatable *prev) override;
    virtual void EndEditParams(IObjParam *ip, ULONG flags, Animatable *next) override;

    virtual int HitTest(TimeValue t, INode* inode, int type, int crossing, int flags, IPoint2 *p, ViewExp *vpt) override;

    virtual const MCHAR* GetObjectName() override;

    virtual int NumRefs() override  { return 1; }
    virtual RefTargetHandle	GetReference(int i) override;
    virtual void SetReference(int	i, RefTargetHandle rtarg) override;
    virtual int NumParamBlocks() override { return 1; }
    virtual IParamBlock2* GetParamBlock(int i) override;
    virtual IParamBlock2* GetParamBlockByID(BlockID id) override;

    virtual void InitNodeName(MSTR& s) override;

    virtual RefResult ReferenceMaker::NotifyRefChanged(const Interval &,RefTargetHandle,PartID &,RefMessage,BOOL);

    virtual CreateMouseCallBack* GetCreateMouseCallBack(void);

    virtual ObjectState Eval(TimeValue);

    virtual RefResult EvalLightState(TimeValue,Interval &,LightState *);

    virtual void SetUseLight(int);

    virtual BOOL GetUseLight(void);

    virtual void SetHotspot(TimeValue,float);

    virtual float GetHotspot(TimeValue,Interval &);

    virtual void SetFallsize(TimeValue,float);

    virtual float GetFallsize(TimeValue,Interval &);

    virtual void SetAtten(TimeValue,int,float);

    virtual float GetAtten(TimeValue,int,Interval &);

    virtual void SetTDist(TimeValue,float);

    virtual float GetTDist(TimeValue,Interval &);

    virtual void SetConeDisplay(int,int);

    virtual BOOL GetConeDisplay(void);

    virtual void SetExtendedDisplay(int flags) override;

    virtual int Display( TimeValue t, INode* inode, ViewExp* vpt, int flags ) override;
    virtual void GetWorldBoundBox(TimeValue t, INode *mat, ViewExp* vpt, Box3& box) override;
    virtual void GetLocalBoundBox(TimeValue t, INode *mat, ViewExp* vpt, Box3& box ) override;
    virtual void GetDeformBBox( TimeValue t, Box3& box, Matrix3 *tm, BOOL useSel) override;
    BOOL virtual HasViewDependentBoundingBox() override { return true; }
    
    virtual BOOL DoOwnSelectHilite()override { return TRUE; }

    virtual Object* MakeShallowCopy(ChannelMask channels);

    //virtual ObjLightDesc* CreateLightDesc(INode* n, BOOL forceShadowBuffer = FALSE) override;

    enum MainParamID
    {
        kMainParamID_On = 0,
        kMainParamID_Map = 1,
    };

private:

    virtual void NotifyTarget(int message, ReferenceMaker* hMaker) override;
    INode* GetNodeRef(ReferenceMaker *rm);

    enum ChunkID 
    {
        kChunk_Box = 0x0011
    };


    static ParamBlockDesc2 m_mainPBDesc;

    IParamBlock2* m_mainPB;

    Mesh m_mesh;
    bool m_meshBuilt = false;

    int m_extDispFlags;

    MAXtoATestPlugin_translationInterface m_ti;

};
